#include <iostream>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include "servo.h"

using namespace std;

#define PORT "3490"

int main()
{
  int port;
  char buf[8];
  char m1[4];
  char m2[4];
  addrinfo hints, *result;
  int servfd, clientfd;
  sockaddr_storage their_addr;
  int yes = 1;
  //Clear the hints struct
  memset(&hints, 0, sizeof hints);
  
  //Set up hints struct
  hints.ai_family = AF_UNSPEC; //ipv4 or ipv6, doesn't matter
  hints.ai_socktype = SOCK_STREAM; //use socket streams
  hints.ai_flags = AI_PASSIVE; //use my ip

  getaddrinfo(NULL, PORT, &hints, &result);

  servfd = socket(result->ai_family,result->ai_socktype,result->ai_protocol);
  setsockopt(servfd, SOL_SOCKET, SO_REUSEADDR, &yes, sizeof(int));

  bind(servfd, result->ai_addr, result->ai_addrlen);

  freeaddrinfo(result);
  listen(servfd, 10);

  while(1)
  {
    cout << "Waiting for connections..." << endl;
    socklen_t addrsize = sizeof their_addr;
    clientfd = accept(servfd, (struct sockaddr*)&their_addr,&addrsize);
    port = serialOpen("/dev/ttyUSB0");
    int numbytes = 1;
    int motor1, motor2;
    while(numbytes > 0)
    {
      if(numbytes > 0)
      {
        for(int i = 0; i < 4; i++)
        {
          m1[i] = buf[i];
        }
        for(int i = 0; i < 4; i++)
        {
          m2[i] = buf[i+4];
        }
        memcpy(&motor1, &m1, sizeof motor1);
        memcpy(&motor2, &m2, sizeof motor2);
        cout << "Received: " << numbytes << " Bytes, " << (motor1/364)+90 << "		" << (motor2/364)+90 << endl;
        updateVex((char)((motor1/364)+90),(char)((motor2/364)+90),port);
      }
      numbytes = recv(clientfd,&buf,sizeof buf,0);
    }
    usleep(50000);
    updateVex((char)90,(char)90,port);
    close(port);
  }
  close(clientfd);
  close(port);
  return 0;
}
